/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.granite;

import icyllis.arc3d.core.BlendMode;
import icyllis.arc3d.core.SLDataType;
import icyllis.arc3d.granite.FragmentNode;
import icyllis.arc3d.granite.FragmentStage;
import java.util.EnumMap;
import java.util.Formatter;
import java.util.IdentityHashMap;
import java.util.StringJoiner;

public class ShaderCodeSource {
    private static final FragmentStage.Uniform[] PAINT_COLOR_UNIFORMS = new FragmentStage.Uniform[]{new FragmentStage.Uniform(16, "SV_PaintColor")};
    private static final FragmentStage.Uniform INV_IMAGE_SIZE = new FragmentStage.Uniform(14, "u_InvImageSize");
    private static final FragmentStage.Uniform SUBSET = new FragmentStage.Uniform(16, "u_Subset");
    private static final FragmentStage.Uniform TILE_MODE_X = new FragmentStage.Uniform(27, "u_TileModeX");
    private static final FragmentStage.Uniform TILE_MODE_Y = new FragmentStage.Uniform(27, "u_TileModeY");
    private static final FragmentStage.Uniform XFORM_FLAGS = new FragmentStage.Uniform(27, "u_XformFlags");
    private static final FragmentStage.Uniform XFORM_SRC_TF = new FragmentStage.Uniform(16, "u_XformSrcTf", 2);
    private static final FragmentStage.Uniform XFORM_GAMUT_TRANSFORM = new FragmentStage.Uniform(18, "u_XformGamutTransform");
    private static final FragmentStage.Uniform XFORM_DST_TF = new FragmentStage.Uniform(16, "u_XformDstTf", 2);
    private static final FragmentStage.Uniform GRAD_COLOR_SPACE = new FragmentStage.Uniform(27, "u_ColorSpace");
    private static final FragmentStage.Uniform GRAD_DO_UNPREMUL = new FragmentStage.Uniform(27, "u_DoUnpremul");
    private static final FragmentStage.Uniform GRAD_BIAS = new FragmentStage.Uniform(13, "u_Bias");
    private static final FragmentStage.Uniform GRAD_SCALE = new FragmentStage.Uniform(13, "u_Scale");
    private static final FragmentStage.Uniform GRAD_4_COLORS = new FragmentStage.Uniform(16, "u_Colors", 4);
    private static final FragmentStage.Uniform GRAD_4_OFFSETS = new FragmentStage.Uniform(16, "u_Offsets");
    private static final FragmentStage.Uniform GRAD_8_COLORS = new FragmentStage.Uniform(16, "u_Colors", 8);
    private static final FragmentStage.Uniform GRAD_8_OFFSETS = new FragmentStage.Uniform(16, "u_Offsets", 2);
    public static final String ARC_ERROR = "vec4 arc_error(vec2 coords) {\n    return mix(vec4(1.0), vec4(0.0,1.0,0.0,1.0),\n           bool((int(coords.x) >> 3 ^ int(coords.y) >> 3) & 1));\n}\n";
    public static final String ARC_PASSTHROUGH = "vec4 arc_passthrough(vec4 inColor) {\n    return inColor;\n}\n";
    public static final String ARC_SOLID_COLOR = "vec4 arc_solid_color(vec4 color) {\n    return color;\n}\n";
    public static final String ARC_RGB_OPAQUE = "vec4 arc_rgb_opaque(vec4 paintColor) {\n    return vec4(paintColor.rgb, 1.0);\n}\n";
    public static final String ARC_ALPHA_ONLY = "vec4 arc_alpha_only(vec4 paintColor) {\n    return vec4(0.0, 0.0, 0.0, paintColor.a);\n}\n";
    private static final String PRIV_TRANSFER_FUNCTION = "float _transfer_function(float x, vec4 tf[2]) {\n    float G = tf[0][0], A = tf[0][1], B = tf[0][2], C = tf[0][3],\n          D = tf[1][0], E = tf[1][1], F = tf[1][2];\n    float s = sign(x);\n    x = abs(x);\n    x = mix(pow(A * x + B, G) + E, (C * x) + F, x < D);\n    return s * x;\n}\n";
    private static final String PRIV_INV_TRANSFER_FUNCTION = "float _inv_transfer_function(float x, vec4 tf[2]) {\n    float G = tf[0][0], A = tf[0][1], B = tf[0][2], C = tf[0][3],\n          D = tf[1][0], E = tf[1][1], F = tf[1][2];\n    float s = sign(x);\n    x = abs(x);\n    x = mix((pow(x - E, 1.0 / G) - B) / A, (x - F) / C, x < D * C);\n    return s * x;\n}\n";
    public static final String ARC_COLOR_SPACE_TRANSFORM = "vec4 arc_color_space_transform(vec4 color,\n                               int flags,\n                               vec4 srcTf[2],\n                               mat3 gamutTransform,\n                               vec4 dstTf[2]) {\n    const int kColorSpaceXformFlagUnpremul = 0x1;\n    const int kColorSpaceXformFlagLinearize = 0x2;\n    const int kColorSpaceXformFlagGamutTransform = 0x4;\n    const int kColorSpaceXformFlagEncode = 0x8;\n    const int kColorSpaceXformFlagPremul = 0x10;\n\n    if (bool(flags & kColorSpaceXformFlagUnpremul)) {\n        color.rgb /= max(color.a, 1e-7);\n    }\n\n    if (bool(flags & kColorSpaceXformFlagLinearize)) {\n        color.r = _transfer_function(color.r, srcTf);\n        color.g = _transfer_function(color.g, srcTf);\n        color.b = _transfer_function(color.b, srcTf);\n    }\n    if (bool(flags & kColorSpaceXformFlagGamutTransform)) {\n        color.rgb = gamutTransform * color.rgb;\n    }\n    if (bool(flags & kColorSpaceXformFlagEncode)) {\n        color.r = _inv_transfer_function(color.r, dstTf);\n        color.g = _inv_transfer_function(color.g, dstTf);\n        color.b = _inv_transfer_function(color.b, dstTf);\n    }\n\n    if (bool(flags & kColorSpaceXformFlagPremul)) {\n        color.rgb *= color.a;\n    }\n    return color;\n}\n";
    private static final String PRIV_TILE_GRAD = "vec2 _tile_grad(int tileMode, vec2 t) {\n    const int kTileModeRepeat = 0;\n    const int kTileModeMirror = 1;\n    const int kTileModeClamp  = 2;\n    const int kTileModeDecal  = 3;\n\n    switch (tileMode) {\n        case kTileModeRepeat:\n            t.x = fract(t.x);\n            break;\n\n        case kTileModeMirror: {\n            float s = t.x - 1.0;\n            s = s - 2.0 * floor(s * 0.5) - 1.0;\n            t.x = abs(s);\n            break;\n        }\n\n        case kTileModeClamp:\n            t.x = clamp(t.x, 0.0, 1.0);\n            break;\n\n        case kTileModeDecal: {\n            vec2 s = vec2(step(0.0, t.x), step(t.x, 1.0));\n            t.y = s.x * s.y - 0.5;\n            break;\n        }\n    }\n    return t;\n}\n";
    private static final String PRIV_COLORIZE_GRAD_4 = "vec4 _colorize_grad_4(vec4 colors[4], vec4 offsets, vec2 t) {\n    vec4 result;\n    if (t.y < 0.0) {\n        result = vec4(0);\n    } else if (t.x <= offsets[0]) {\n        result = colors[0];\n    } else if (t.x < offsets[1]) {\n        result = mix(colors[0], colors[1], (t.x        - offsets[0]) /\n                                           (offsets[1] - offsets[0]));\n    } else if (t.x < offsets[2]) {\n        result = mix(colors[1], colors[2], (t.x        - offsets[1]) /\n                                           (offsets[2] - offsets[1]));\n    } else if (t.x < offsets[3]) {\n        result = mix(colors[2], colors[3], (t.x        - offsets[2]) /\n                                           (offsets[3] - offsets[2]));\n    } else {\n        result = colors[3];\n    }\n    return result;\n}\n";
    private static final String PRIV_COLORIZE_GRAD_8 = "vec4 _colorize_grad_8(vec4 colors[8], vec4 offsets[2], vec2 t) {\n    vec4 result;\n    if (t.y < 0.0) {\n        result = vec4(0);\n    } else if (t.x < offsets[1][0]) {\n        if (t.x < offsets[0][2]) {\n            if (t.x <= offsets[0][0]) {\n                result = colors[0];\n            } else if (t.x < offsets[0][1]) {\n                result = mix(colors[0], colors[1],\n                             (t.x           - offsets[0][0]) /\n                             (offsets[0][1] - offsets[0][0]));\n            } else {\n                result = mix(colors[1], colors[2],\n                             (t.x           - offsets[0][1]) /\n                             (offsets[0][2] - offsets[0][1]));\n            }\n        } else {\n            if (t.x < offsets[0][3]) {\n                result = mix(colors[2], colors[3],\n                             (t.x           - offsets[0][2]) /\n                             (offsets[0][3] - offsets[0][2]));\n            } else {\n                result = mix(colors[3], colors[4],\n                             (t.x           - offsets[0][3]) /\n                             (offsets[1][0] - offsets[0][3]));\n            }\n        }\n    } else {\n        if (t.x < offsets[1][2]) {\n            if (t.x < offsets[1][1]) {\n                result = mix(colors[4], colors[5],\n                             (t.x           - offsets[1][0]) /\n                             (offsets[1][1] - offsets[1][0]));\n            } else {\n                result = mix(colors[5], colors[6],\n                             (t.x           - offsets[1][1]) /\n                             (offsets[1][2] - offsets[1][1]));\n            }\n        } else {\n            if (t.x < offsets[1][3]) {\n                result = mix(colors[6], colors[7],\n                             (t.x           - offsets[1][2]) /\n                             (offsets[1][3] - offsets[1][2]));\n            } else {\n                result = colors[7];\n            }\n        }\n    }\n    return result;\n}\n";
    private static final String PRIV_LINEAR_GRAD_LAYOUT = "vec2 _linear_grad_layout(vec2 pos) {\n    return vec2(pos.x + 0.00001, 1);\n}\n";
    private static final String PRIV_RADIAL_GRAD_LAYOUT = "vec2 _radial_grad_layout(vec2 pos) {\n    float t = length(pos);\n    return vec2(t, 1);\n}\n";
    private static final String PRIV_ANGULAR_GRAD_LAYOUT = "vec2 _angular_grad_layout(vec2 pos, float bias, float scale) {\n    float angle = mix(sign(pos.y) * -1.5707963267948966, atan(-pos.y, -pos.x), pos.x != 0.0);\n    float t = (angle * 0.1591549430918953 + 0.5 + bias) * scale;\n    return vec2(t, 1);\n}\n";
    private static final String PRIV_CSS_LAB_TO_XYZ = "vec3 _css_lab_to_xyz(vec3 lab) {\n    const float B = 841.0 / 108.0;\n    const float C = 4.0 / 29.0;\n    const float D = 6.0 / 29.0;\n\n    vec3 f;\n    f[1] = (lab[0] + 16.0) / 116.0;\n    f[0] = f[1] + (lab[1] * 0.002);\n    f[2] = f[1] - (lab[2] * 0.005);\n\n    vec3 xyz = mix((1.0 / B) * (f - C), pow(f, vec3(3)), greaterThan(f, vec3(D)));\n\n    const vec3 D50 = vec3(0.964212, 1.0, 0.825188);\n    return xyz * D50;\n}\n";
    private static final String PRIV_CSS_HCL_TO_LAB = "vec3 _css_hcl_to_lab(vec3 hcl) {\n    return vec3(\n        hcl[2],\n        hcl[1] * cos(radians(hcl[0])),\n        hcl[1] * sin(radians(hcl[0]))\n    );\n}\n";
    private static final String PRIV_CSS_OKLAB_TO_LINEAR_SRGB = "vec3 _css_oklab_to_linear_srgb(vec3 oklab) {\n    float l_ = oklab.x + 0.3963377774 * oklab.y + 0.2158037573 * oklab.z,\n          m_ = oklab.x - 0.1055613458 * oklab.y - 0.0638541728 * oklab.z,\n          s_ = oklab.x - 0.0894841775 * oklab.y - 1.2914855480 * oklab.z;\n\n    float l = l_*l_*l_,\n          m = m_*m_*m_,\n          s = s_*s_*s_;\n\n    return vec3(\n        +4.0767416621 * l - 3.3077115913 * m + 0.2309699292 * s,\n        -1.2684380046 * l + 2.6097574011 * m - 0.3413193965 * s,\n        -0.0041960863 * l - 0.7034186147 * m + 1.7076147010 * s\n    );\n}\n";
    private static final String PRIV_OKLAB_GAMUT_MAP_TO_LINEAR_SRGB = "vec3 _css_oklab_gamut_map_to_linear_srgb(vec3 oklab) {\n    // Constants for the normal vector of the plane formed by white, black, and\n    // the specified vertex of the gamut.\n    const vec2 normal_R = vec2(0.409702, -0.912219);\n    const vec2 normal_M = vec2(-0.397919, -0.917421);\n    const vec2 normal_B = vec2(-0.906800, 0.421562);\n    const vec2 normal_C = vec2(-0.171122, 0.985250);\n    const vec2 normal_G = vec2(0.460276, 0.887776);\n    const vec2 normal_Y = vec2(0.947925, 0.318495);\n\n    // For the triangles formed by white (W) or black (K) with the vertices\n    // of Yellow and Red (YR), Red and Magenta (RM), etc, the constants to be\n    // used to compute the intersection of a line of constant hue and luminance\n    // with that plane.\n    const float c0_YR = 0.091132;\n    const vec2 cW_YR = vec2(0.070370, 0.034139);\n    const vec2 cK_YR = vec2(0.018170, 0.378550);\n    const float c0_RM = 0.113902;\n    const vec2 cW_RM = vec2(0.090836, 0.036251);\n    const vec2 cK_RM = vec2(0.226781, 0.018764);\n    const float c0_MB = 0.161739;\n    const vec2 cW_MB = vec2(-0.008202, -0.264819);\n    const vec2 cK_MB = vec2( 0.187156, -0.284304);\n    const float c0_BC = 0.102047;\n    const vec2 cW_BC = vec2(-0.014804, -0.162608);\n    const vec2 cK_BC = vec2(-0.276786,  0.004193);\n    const float c0_CG = 0.092029;\n    const vec2 cW_CG = vec2(-0.038533, -0.001650);\n    const vec2 cK_CG = vec2(-0.232572, -0.094331);\n    const float c0_GY = 0.081709;\n    const vec2 cW_GY = vec2(-0.034601, -0.002215);\n    const vec2 cK_GY = vec2( 0.012185,  0.338031);\n\n    vec2 ab = oklab.yz;\n\n    // Find the planes to intersect with and set the constants based on those\n    // planes.\n    float c0;\n    vec2 cW;\n    vec2 cK;\n    if (dot(ab, normal_R) < 0.0) {\n        if (dot(ab, normal_G) < 0.0) {\n            if (dot(ab, normal_C) < 0.0) {\n                c0 = c0_BC; cW = cW_BC; cK = cK_BC;\n            } else {\n                c0 = c0_CG; cW = cW_CG; cK = cK_CG;\n            }\n        } else {\n            if (dot(ab, normal_Y) < 0.0) {\n                c0 = c0_GY; cW = cW_GY; cK = cK_GY;\n            } else {\n                c0 = c0_YR; cW = cW_YR; cK = cK_YR;\n            }\n        }\n    } else {\n        if (dot(ab, normal_B) < 0.0) {\n            if (dot(ab, normal_M) < 0.0) {\n                c0 = c0_RM; cW = cW_RM; cK = cK_RM;\n            } else {\n                c0 = c0_MB; cW = cW_MB; cK = cK_MB;\n            }\n        } else {\n            c0 = c0_BC; cW = cW_BC; cK = cK_BC;\n        }\n    }\n\n    // Perform the intersection.\n    float alpha = 1.0;\n\n    // Intersect with the plane with white.\n    float w_denom = dot(cW, ab);\n    if (w_denom > 0.0) {\n        float one_minus_L = 1.0 - oklab.r;\n        float w_num = c0*one_minus_L;\n        if (w_num < w_denom) {\n            alpha = min(alpha, w_num / w_denom);\n        }\n    }\n\n    // Intersect with the plane with black.\n    float k_denom = dot(cK, ab);\n    if (k_denom > 0.0) {\n        float L = oklab.r;\n        float k_num = c0*L;\n        if (k_num < k_denom) {\n            alpha = min(alpha,  k_num / k_denom);\n        }\n    }\n\n    // Attenuate the ab coordinate by alpha.\n    oklab.yz *= alpha;\n\n    return _css_oklab_to_linear_srgb(oklab);\n}\n";
    private static final String PRIV_CSS_HSL_TO_SRGB = "vec3 _css_hsl_to_srgb(vec3 hsl) {\n    hsl.x = mod(hsl.x, 360.0);\n    if (hsl.x < 0.0) {\n        hsl.x += 360.0;\n    }\n\n    hsl.yz /= 100.0;\n\n    vec3 k = mod(vec3(0, 8, 4) + hsl.x/30.0, 12.0);\n    float a = hsl.y * min(hsl.z, 1.0 - hsl.z);\n    return hsl.z - a * clamp(min(k - 3.0, 9.0 - k), -1.0, 1.0);\n}\n";
    private static final String PRIV_CSS_HWB_TO_SRGB = "vec3 _css_hwb_to_srgb(vec3 hwb) {\n    vec3 rgb;\n    hwb.yz /= 100.0;\n    if (hwb.y + hwb.z >= 1.0) {\n        // grayscale\n        rgb = vec3(hwb.y / (hwb.y + hwb.z));\n    } else {\n        rgb = _css_hsl_to_srgb(vec3(hwb.x, 100, 50));\n        rgb *= (1.0 - hwb.y - hwb.z);\n        rgb += hwb.y;\n    }\n    return rgb;\n}\n";
    private static final String PRIV_INTERPOLATED_TO_RGB_UNPREMUL = "vec4 _interpolated_to_rgb_unpremul(vec4 color, int colorSpace, int doUnpremul) {\n    const int kDestination   = 0;\n    const int kSRGB          = 1;\n    const int kSRGBLinear    = 2;\n    const int kLab           = 3;\n    const int kOKLab         = 4;\n    const int kOKLabGamutMap = 5;\n    const int kHSL           = 6;\n    const int kHWB           = 7;\n    const int kLCH           = 8;\n    const int kOKLCH         = 9;\n    const int kOKLCHGamutMap = 10;\n\n    if (bool(doUnpremul)) {\n        switch (colorSpace) {\n            case kLab:\n            case kOKLab:\n            case kOKLabGamutMap: color.rgb /= max(color.a, 1e-7); break;\n            case kHSL:\n            case kHWB:\n            case kLCH:\n            case kOKLCH:\n            case kOKLCHGamutMap: color.gb /= max(color.a, 1e-7); break;\n        }\n    }\n    switch (colorSpace) {\n        case kLab:\n            color.rgb = _css_lab_to_xyz(color.rgb);\n            break;\n        case kOKLab:\n            color.rgb = _css_oklab_to_linear_srgb(color.rgb);\n            break;\n        case kOKLabGamutMap:\n            color.rgb = _css_oklab_gamut_map_to_linear_srgb(color.rgb);\n            break;\n        case kHSL:\n            color.rgb = _css_hsl_to_srgb(color.rgb);\n            break;\n        case kHWB:\n            color.rgb = _css_hwb_to_srgb(color.rgb);\n            break;\n        case kLCH:\n            color.rgb = _css_lab_to_xyz(_css_hcl_to_lab(color.rgb));\n            break;\n        case kOKLCH:\n            color.rgb = _css_oklab_to_linear_srgb(_css_hcl_to_lab(color.rgb));\n            break;\n        case kOKLCHGamutMap:\n            color.rgb = _css_oklab_gamut_map_to_linear_srgb(_css_hcl_to_lab(color.rgb));\n            break;\n    }\n    return color;\n}\n";
    public static final String ARC_LINEAR_GRAD_4_SHADER = "vec4 arc_linear_grad_4_shader(vec2 coords,\n                              vec4 colors[4],\n                              vec4 offsets,\n                              int tileMode,\n                              int colorSpace,\n                              int doUnpremul) {\n    vec2 t = _linear_grad_layout(coords);\n    t = _tile_grad(tileMode, t);\n    vec4 color = _colorize_grad_4(colors, offsets, t);\n    return _interpolated_to_rgb_unpremul(color, colorSpace, doUnpremul);\n}\n";
    public static final String ARC_LINEAR_GRAD_8_SHADER = "vec4 arc_linear_grad_8_shader(vec2 coords,\n                              vec4 colors[8],\n                              vec4 offsets[2],\n                              int tileMode,\n                              int colorSpace,\n                              int doUnpremul) {\n    vec2 t = _linear_grad_layout(coords);\n    t = _tile_grad(tileMode, t);\n    vec4 color = _colorize_grad_8(colors, offsets, t);\n    return _interpolated_to_rgb_unpremul(color, colorSpace, doUnpremul);\n}\n";
    public static final String ARC_RADIAL_GRAD_4_SHADER = "vec4 arc_radial_grad_4_shader(vec2 coords,\n                              vec4 colors[4],\n                              vec4 offsets,\n                              int tileMode,\n                              int colorSpace,\n                              int doUnpremul) {\n    vec2 t = _radial_grad_layout(coords);\n    t = _tile_grad(tileMode, t);\n    vec4 color = _colorize_grad_4(colors, offsets, t);\n    return _interpolated_to_rgb_unpremul(color, colorSpace, doUnpremul);\n}\n";
    public static final String ARC_RADIAL_GRAD_8_SHADER = "vec4 arc_radial_grad_8_shader(vec2 coords,\n                              vec4 colors[8],\n                              vec4 offsets[2],\n                              int tileMode,\n                              int colorSpace,\n                              int doUnpremul) {\n    vec2 t = _radial_grad_layout(coords);\n    t = _tile_grad(tileMode, t);\n    vec4 color = _colorize_grad_8(colors, offsets, t);\n    return _interpolated_to_rgb_unpremul(color, colorSpace, doUnpremul);\n}\n";
    public static final String ARC_ANGULAR_GRAD_4_SHADER = "vec4 arc_angular_grad_4_shader(vec2 coords,\n                               vec4 colors[4],\n                               vec4 offsets,\n                               float bias,\n                               float scale,\n                               int tileMode,\n                               int colorSpace,\n                               int doUnpremul) {\n    vec2 t = _angular_grad_layout(coords, bias, scale);\n    t = _tile_grad(tileMode, t);\n    vec4 color = _colorize_grad_4(colors, offsets, t);\n    return _interpolated_to_rgb_unpremul(color, colorSpace, doUnpremul);\n}\n";
    public static final String ARC_ANGULAR_GRAD_8_SHADER = "vec4 arc_angular_grad_8_shader(vec2 coords,\n                               vec4 colors[8],\n                               vec4 offsets[2],\n                               float bias,\n                               float scale,\n                               int tileMode,\n                               int colorSpace,\n                               int doUnpremul) {\n    vec2 t = _angular_grad_layout(coords, bias, scale);\n    t = _tile_grad(tileMode, t);\n    vec4 color = _colorize_grad_8(colors, offsets, t);\n    return _interpolated_to_rgb_unpremul(color, colorSpace, doUnpremul);\n}\n";
    private static final String PRIV_TILE = "float _tile(int tileMode, float f, float low, float high) {\n    const int kTileModeRepeat = 0;\n    const int kTileModeMirror = 1;\n    const int kTileModeClamp  = 2;\n    const int kTileModeDecal  = 3;\n\n    switch (tileMode) {\n        case kTileModeRepeat: {\n            float length = high - low;\n            f = mod(f - low, length) + low;\n            break;\n        }\n\n        case kTileModeMirror: {\n            float length = high - low;\n            float t = mod(f - low, length * 2.0);\n            f = mix(t, length * 2.0 - t, step(length, t)) + low;\n            break;\n        }\n\n        case kTileModeClamp:\n            f = clamp(f, low, high);\n            break;\n\n        default: // kTileModeDecal\n            break;\n    }\n    return f;\n}\n";
    private static final String PRIV_SAMPLE_IMAGE_SUBSET = "vec4 _sample_image_subset(vec2 pos,\n                          vec2 invImageSize,\n                          vec4 subset,\n                          int tileModeX,\n                          int tileModeY,\n                          int filterMode,\n                          vec2 linearFilterInset,\n                          sampler2D s) {\n    const int kTileModeRepeat = 0;\n    const int kTileModeMirror = 1;\n    const int kTileModeClamp  = 2;\n    const int kTileModeDecal  = 3;\n    const int kFilterModeNearest = 0;\n    const int kFilterModeLinear  = 1;\n    const float kLinearInset = 0.5 + 0.00001;\n\n    // Do hard-edge shader transitions to the border color for nearest-neighbor decal tiling at the\n    // subset boundaries. Snap the input coordinates to nearest neighbor before comparing to the\n    // subset rect, to avoid GPU interpolation errors.\n    vec4 test = vec4(1.0);\n    if (tileModeX == kTileModeDecal && filterMode == kFilterModeNearest) {\n        float snappedX = floor(pos.x) + 0.5;\n        test.xz = vec2(step(subset.x, snappedX), step(snappedX, subset.z));\n    }\n    if (tileModeY == kTileModeDecal && filterMode == kFilterModeNearest) {\n        float snappedY = floor(pos.y) + 0.5;\n        test.yw = vec2(step(subset.y, snappedY), step(snappedY, subset.w));\n    }\n    if (!all(bvec4(test))) {\n        return vec4(0);\n    }\n\n    pos.x = _tile(tileModeX, pos.x, subset.x, subset.z);\n    pos.y = _tile(tileModeY, pos.y, subset.y, subset.w);\n\n    // Clamp to an inset subset to prevent sampling neighboring texels when coords fall exactly at\n    // texel boundaries.\n    vec4 insetClamp;\n    if (filterMode == kFilterModeNearest) {\n        insetClamp = vec4(floor(subset.xy) + kLinearInset, ceil(subset.zw) - kLinearInset);\n    } else {\n        insetClamp = vec4(subset.xy + linearFilterInset.x, subset.zw - linearFilterInset.y);\n    }\n    vec2 clampedPos = clamp(pos, insetClamp.xy, insetClamp.zw);\n    vec4 color = texture(s, clampedPos * invImageSize);\n\n    if (filterMode == kFilterModeLinear) {\n        // Remember the amount the coord moved for clamping. This is used to implement shader-based\n        // filtering for repeat and decal tiling.\n        vec2 error = pos - clampedPos;\n        vec2 absError = abs(error);\n\n        // Do 1 or 3 more texture reads depending on whether both x and y tiling modes are repeat\n        // and whether we're near a single subset edge or a corner. Then blend the multiple reads\n        // using the error values calculated above.\n        bvec2 sampleExtra = bvec2(tileModeX == kTileModeRepeat,\n                                  tileModeY == kTileModeRepeat);\n        if (any(sampleExtra)) {\n            float extraCoordX;\n            float extraCoordY;\n            vec4 extraColorX;\n            vec4 extraColorY;\n            if (sampleExtra.x) {\n                extraCoordX = mix(insetClamp.z, insetClamp.x, error.x > 0.0);\n                extraColorX = texture(s, vec2(extraCoordX, clampedPos.y) * invImageSize);\n            }\n            if (sampleExtra.y) {\n                extraCoordY = mix(insetClamp.w, insetClamp.y, error.y > 0.0);\n                extraColorY = texture(s, vec2(clampedPos.x, extraCoordY) * invImageSize);\n            }\n            if (all(sampleExtra)) {\n                vec4 extraColorXY = texture(s, vec2(extraCoordX, extraCoordY) * invImageSize);\n                color = mix(mix(color, extraColorX, absError.x),\n                            mix(extraColorY, extraColorXY, absError.x),\n                            absError.y);\n            } else if (sampleExtra.x) {\n                color = mix(color, extraColorX, absError.x);\n            } else if (sampleExtra.y) {\n                color = mix(color, extraColorY, absError.y);\n            }\n        }\n\n        // Do soft edge shader filtering for decal tiling and linear filtering using the error\n        // values calculated above.\n        color *= mix(1.0, max(1 - absError.x, 0), tileModeX == kTileModeDecal);\n        color *= mix(1.0, max(1 - absError.y, 0), tileModeY == kTileModeDecal);\n    }\n\n    return color;\n}\n";
    private static final String PRIV_SAMPLE_CUBIC_IMAGE_SUBSET = "vec4 _sample_cubic_image_subset(vec2 pos,\n                                vec4 subset,\n                                int tileModeX,\n                                int tileModeY,\n                                sampler2D s) {\n    const int kTileModeRepeat = 0;\n    const int kTileModeMirror = 1;\n    const int kTileModeClamp  = 2;\n    const int kTileModeDecal  = 3;\n    const float kLinearInset = 0.5 + 0.00001;\n\n    vec4 test = vec4(1.0);\n    if (tileModeX == kTileModeDecal) {\n        test.xz = vec2(step(subset.x, pos.x), step(pos.x, subset.z));\n    }\n    if (tileModeY == kTileModeDecal) {\n        test.yw = vec2(step(subset.y, pos.y), step(pos.y, subset.w));\n    }\n    if (!all(bvec4(test))) {\n        return vec4(0);\n    }\n\n    pos.x = _tile(tileModeX, pos.x, subset.x, subset.z);\n    pos.y = _tile(tileModeY, pos.y, subset.y, subset.w);\n\n    // Clamp to an inset subset to prevent sampling neighboring texels when coords fall exactly at\n    // texel boundaries.\n    vec4 insetClamp = vec4(floor(subset.xy) + kLinearInset, ceil(subset.zw) - kLinearInset);\n    vec2 clampedPos = clamp(pos, insetClamp.xy, insetClamp.zw);\n    vec4 color = texelFetch(s, ivec2(clampedPos), 0);\n\n    return color;\n}\n";
    private static final String PRIV_CUBIC_FILTER_IMAGE = "vec4 _cubic_filter_image(vec2 pos,\n                         vec4 subset,\n                         int tileModeX,\n                         int tileModeY,\n                         mat4 coeffs,\n                         int cubicClamp,\n                         sampler2D s) {\n    const int kFilterModeNearest = 0;\n    const int kFilterModeLinear  = 1;\n    const int kCubicClampUnpremul = 0;\n    const int kCubicClampPremul   = 1;\n    const float kLinearInset = 0.5 + 0.00001;\n\n    // Determine pos's fractional offset f between texel centers.\n    vec2 f = fract(pos - 0.5);\n    // Sample 16 points at 1-pixel intervals from [p - 1.5 ... p + 1.5].\n    pos -= 1.5;\n    // Snap to texel centers to prevent sampling neighboring texels.\n    pos = floor(pos) + 0.5;\n\n    vec4 wx = coeffs * vec4(1.0, f.x, f.x * f.x, f.x * f.x * f.x);\n    vec4 wy = coeffs * vec4(1.0, f.y, f.y * f.y, f.y * f.y * f.y);\n    vec4 color = vec4(0);\n    for (int y = 0; y < 4; ++y) {\n        vec4 rowColor = vec4(0);\n        for (int x = 0; x < 4; ++x) {\n            rowColor += wx[x] * _sample_cubic_image_subset(pos + vec2(x, y), subset,\n                                                       tileModeX, tileModeY, s);\n        }\n        color += wy[y] * rowColor;\n    }\n    // Bicubic can send colors out of range, so clamp to get them back in gamut.\n    if (cubicClamp == kCubicClampUnpremul) {\n        color = clamp(color, 0.0, 1.0);\n    } else {\n        color.a = clamp(color.a, 0.0, 1.0);\n        color.rgb = clamp(color.rgb, 0.0, color.a);\n    }\n    return color;\n}\n";
    public static final String ARC_IMAGE_SHADER = "vec4 arc_image_shader(vec2 coords,\n                      vec2 invImageSize,\n                      vec4 subset,\n                      int filterMode,\n                      int tileModeX,\n                      int tileModeY,\n                      sampler2D s) {\n    const float kLinearInset = 0.5 + 0.00001;\n    return _sample_image_subset(coords, invImageSize, subset, tileModeX, tileModeY,\n                             filterMode, vec2(kLinearInset), s);\n}\n";
    public static final String ARC_CUBIC_IMAGE_SHADER = "vec4 arc_cubic_image_shader(vec2 coords,\n                            vec4 subset,\n                            mat4 cubicCoeffs,\n                            int cubicClamp,\n                            int tileModeX,\n                            int tileModeY,\n                            sampler2D s) {\n    return _cubic_filter_image(coords, subset, tileModeX, tileModeY,\n                            cubicCoeffs, cubicClamp, s);\n}\n";
    public static final String ARC_HW_IMAGE_SHADER = "vec4 arc_hw_image_shader(vec2 coords,\n                         vec2 invImageSize,\n                         sampler2D s) {\n    return texture(s, coords * invImageSize);\n}\n";
    public static final String ARC_DITHER_SHADER = "vec4 arc_dither_shader(vec4 color,\n                       float range) {\n    // Unrolled 8x8 Bayer matrix\n    vec2 A = gl_FragCoord.xy;\n    vec2 B = floor(A);\n    float U = fract(B.x * 0.5 + B.y * B.y * 0.75);\n    vec2 C = A * 0.5;\n    vec2 D = floor(C);\n    float V = fract(D.x * 0.5 + D.y * D.y * 0.75);\n    vec2 E = C * 0.5;\n    vec2 F = floor(E);\n    float W = fract(F.x * 0.5 + F.y * F.y * 0.75);\n    float dithering = ((W * 0.25 + V) * 0.25 + U) - (63.0 / 128.0);\n    // For each color channel, add the random offset to the channel value and then clamp\n    // between 0 and alpha to keep the color premultiplied.\n    return vec4(clamp(color.rgb + dithering * range, 0.0, color.a), color.a);\n}\n";
    public static final String BLEND_CLEAR = "vec4 blend_clear(vec4 src, vec4 dst) {\n    return vec4(0);\n}\n";
    public static final String BLEND_SRC = "vec4 blend_src(vec4 src, vec4 dst) {\n    return src;\n}\n";
    public static final String BLEND_DST = "vec4 blend_dst(vec4 src, vec4 dst) {\n    return dst;\n}\n";
    public static final String BLEND_SRC_OVER = "vec4 blend_src_over(vec4 src, vec4 dst) {\n    return src + dst * (1 - src.a);\n}\n";
    public static final String BLEND_DST_OVER = "vec4 blend_dst_over(vec4 src, vec4 dst) {\n    return src * (1 - dst.a) + dst;\n}\n";
    public static final String BLEND_SRC_IN = "vec4 blend_src_in(vec4 src, vec4 dst) {\n    return src * dst.a;\n}\n";
    public static final String BLEND_DST_IN = "vec4 blend_dst_in(vec4 src, vec4 dst) {\n    return dst * src.a;\n}\n";
    public static final String BLEND_SRC_OUT = "vec4 blend_src_out(vec4 src, vec4 dst) {\n    return src * (1 - dst.a);\n}\n";
    public static final String BLEND_DST_OUT = "vec4 blend_dst_out(vec4 src, vec4 dst) {\n    return dst * (1 - src.a);\n}\n";
    public static final String BLEND_SRC_ATOP = "vec4 blend_src_atop(vec4 src, vec4 dst) {\n    return src * dst.a + dst * (1 - src.a);\n}\n";
    public static final String BLEND_DST_ATOP = "vec4 blend_dst_atop(vec4 src, vec4 dst) {\n    return src * (1 - dst.a) + dst * src.a;\n}\n";
    public static final String BLEND_XOR = "vec4 blend_xor(vec4 src, vec4 dst) {\n    return src * (1 - dst.a) + dst * (1 - src.a);\n}\n";
    public static final String BLEND_PLUS = "vec4 blend_plus(vec4 src, vec4 dst) {\n    return src + dst;\n}\n";
    public static final String BLEND_PLUS_CLAMPED = "vec4 blend_plus_clamped(vec4 src, vec4 dst) {\n    return min(src + dst, 1);\n}\n";
    public static final String BLEND_MINUS = "vec4 blend_minus(vec4 src, vec4 dst) {\n    return dst - src;\n}\n";
    public static final String BLEND_MINUS_CLAMPED = "vec4 blend_minus_clamped(vec4 src, vec4 dst) {\n    return max(dst - src, 0);\n}\n";
    public static final String BLEND_MODULATE = "vec4 blend_modulate(vec4 src, vec4 dst) {\n    return src * dst;\n}\n";
    public static final String BLEND_MULTIPLY = "vec4 blend_multiply(vec4 src, vec4 dst) {\n    return src * dst + src * (1 - dst.a) + dst * (1 - src.a);\n}\n";
    public static final String BLEND_SCREEN = "vec4 blend_screen(vec4 src, vec4 dst) {\n    return src + dst - src * dst;\n}\n";
    public static final String BLEND_OVERLAY = "vec4 blend_overlay(vec4 src, vec4 dst) {\n    vec3 s = src.rgb,       d = dst.rgb;\n    vec3 sa = vec3(src.a),  da = vec3(dst.a);\n    return vec4(s * (1 - da) + d * (1 - sa) +\n                    mix(sa * da - 2 * (sa - s) * (da - d),\n                        2 * s * d,\n                        lessThanEqual(2 * d, da)),\n                sa + da * (1 - sa));\n}\n";
    public static final String BLEND_DARKEN = "vec4 blend_darken(vec4 src, vec4 dst) {\n    return src + dst - max(src * dst.a, dst * src.a);\n}\n";
    public static final String BLEND_LIGHTEN = "vec4 blend_lighten(vec4 src, vec4 dst) {\n    return src + dst - min(src * dst.a, dst * src.a);\n}\n";
    public static final String BLEND_COLOR_DODGE = "vec4 blend_color_dodge(vec4 src, vec4 dst) {\n    vec3 s = src.rgb,       d = dst.rgb;\n    vec3 sa = vec3(src.a),  da = vec3(dst.a);\n    return vec4(mix(mix(sa * min(da, d * sa / (sa - s)) + s * (1 - da) + d * (1 - sa),\n                        sa * da + s * (1 - da) + d * (1 - sa),\n                        greaterThanEqual(s, sa)),\n                    s * (1 - da),\n                    lessThanEqual(d, vec3(0))),\n                sa + da * (1 - sa));\n}\n";
    public static final String BLEND_COLOR_BURN = "vec4 blend_color_burn(vec4 src, vec4 dst) {\n    vec3 s = src.rgb,       d = dst.rgb;\n    vec3 sa = vec3(src.a),  da = vec3(dst.a);\n    return vec4(mix(mix(sa * max(vec3(0), da - (da - d) * sa / s) + s * (1 - da) + d * (1 - sa),\n                        d * (1 - sa),\n                        lessThanEqual(s, vec3(0))),\n                    sa * da + s * (1 - da) + d * (1 - sa),\n                    greaterThanEqual(d, da)),\n                sa + da * (1 - sa));\n}\n";
    public static final String BLEND_HARD_LIGHT = "vec4 blend_hard_light(vec4 src, vec4 dst) {\n    vec3 s = src.rgb,       d = dst.rgb;\n    vec3 sa = vec3(src.a),  da = vec3(dst.a);\n    return vec4(s * (1 - da) + d * (1 - sa) +\n                    mix(sa * da - 2 * (sa - s) * (da - d),\n                        2 * s * d,\n                        lessThanEqual(2 * s, sa)),\n                sa + da * (1 - sa));\n}\n";
    public static final String BLEND_SOFT_LIGHT = "vec4 blend_soft_light(vec4 src, vec4 dst) {\n    vec3 s = src.rgb,       d = dst.rgb;\n    vec3 sa = vec3(src.a),  da = vec3(dst.a);\n    vec3 dd = d * d,        dada = da * da;\n    return vec4(mix(mix(d * (sa - 2 * s + 1) + s * (1 - da) - sqrt(d * da) * (sa - 2 * s),\n                        (dada * (s + d * (6 * s - 3 * sa + 1)) + 12 * da * dd * (sa - 2 * s) -\n                              16 * dd * d * (sa - 2 * s) - dada * da * s) / dada,\n                        lessThanEqual(4 * d, da)),\n                    d * d * (sa - 2 * s) / da + s * (1 - da) + d * (2 * s + 1 - sa),\n                    lessThanEqual(2 * s, sa)),\n                sa + da * (1 - sa));\n}\n";
    public static final String BLEND_DIFFERENCE = "vec4 blend_difference(vec4 src, vec4 dst) {\n    return vec4(src.rgb + dst.rgb - 2 * min(src.rgb * dst.a, dst.rgb * src.a),\n                src.a + dst.a * (1 - src.a));\n}\n";
    public static final String BLEND_EXCLUSION = "vec4 blend_exclusion(vec4 src, vec4 dst) {\n    return vec4(src.rgb + dst.rgb - 2 * (src.rgb * dst.rgb),\n                src.a + dst.a * (1 - src.a));\n}\n";
    public static final String BLEND_SUBTRACT = "vec4 blend_subtract(vec4 src, vec4 dst) {\n    return vec4(src.rgb * (1 - dst.a) + dst.rgb - min(src.rgb * dst.a, dst.rgb * src.a),\n                src.a + dst.a * (1 - src.a));\n}\n";
    public static final String BLEND_DIVIDE = "vec4 blend_divide(vec4 src, vec4 dst) {\n    vec3 numer = dst.rgb * src.a;\n    vec3 denom = src.rgb * dst.a;\n    vec3 c = src.rgb * (1 - dst.a) + dst.rgb * (1 - src.a);\n    return vec4(mix(clamp(numer / denom, 0, 1) * src.a * dst.a + c,\n                    mix(src.a * dst.a + c,\n                        c,\n                        equal(numer, vec3(0))),\n                    equal(denom, vec3(0))),\n                src.a + dst.a * (1 - src.a));\n}\n";
    public static final String BLEND_LINEAR_DODGE = "vec4 blend_linear_dodge(vec4 src, vec4 dst) {\n    return vec4(min(src.rgb + dst.rgb, src.a * dst.a + src.rgb * (1 - dst.a) + dst.rgb * (1 - src.a)),\n                src.a + dst.a * (1 - src.a));\n}\n";
    public static final String BLEND_LINEAR_BURN = "vec4 blend_linear_burn(vec4 src, vec4 dst) {\n    return vec4(max(src.rgb + dst.rgb - src.a * dst.a, src.rgb * (1 - dst.a) + dst.rgb * (1 - src.a)),\n                src.a + dst.a * (1 - src.a));\n}\n";
    public static final String BLEND_VIVID_LIGHT = "vec4 blend_vivid_light(vec4 src, vec4 dst) {\n    vec3 s = src.rgb,       d = dst.rgb;\n    vec3 sa = vec3(src.a),  da = vec3(dst.a);\n    return vec4(mix(mix(sa * min(da, d * sa / (2 * (sa - s))) + s * (1 - da) + d * (1 - sa),\n                        sa * da + s * (1 - da) + d * (1 - sa),\n                        greaterThanEqual(s, sa)),\n                    mix(sa * max(vec3(0), da - (da - d) * sa / (2 * s)) + s * (1 - da) + d * (1 - sa),\n                        d * (1 - sa),\n                        lessThanEqual(s, vec3(0))),\n                    lessThan(2 * s, sa)),\n                sa + da * (1 - sa));\n}\n";
    public static final String BLEND_LINEAR_LIGHT = "vec4 blend_linear_light(vec4 src, vec4 dst) {\n    vec3 s = src.rgb,       d = dst.rgb;\n    vec3 sa = vec3(src.a),  da = vec3(dst.a);\n    return vec4(clamp(2 * s * da + d * sa - sa * da, vec3(0), sa * da) +\n                      s * (1 - da) + d * (1 - sa),\n                sa + da * (1 - sa));\n}\n";
    public static final String BLEND_PIN_LIGHT = "vec4 blend_pin_light(vec4 src, vec4 dst) {\n    vec3 s = src.rgb,       d = dst.rgb;\n    vec3 sa = vec3(src.a),  da = vec3(dst.a);\n    vec3 x = 2 * s * da;\n    vec3 y = x - sa * da;\n    vec3 z = d * sa;\n    return vec4(s * (1 - da) + d * (1 - sa) +\n                mix(min(x, z),\n                    mix(y,\n                        vec3(0),\n                        lessThan(2 * s, sa)),\n                    greaterThan(y, z)),\n                sa + da * (1 - sa));\n}\n";
    public static final String BLEND_HARD_MIX = "vec4 blend_hard_mix(vec4 src, vec4 dst) {\n    vec3 s = src.rgb,       d = dst.rgb;\n    vec3 sa = vec3(src.a),  da = vec3(dst.a);\n    vec3 b = s * da + d * sa;\n    vec3 c = sa * da;\n    return vec4(s + d - b + mix(c, vec3(0), lessThan(b, c)),\n                sa + da * (1 - sa));\n}\n";
    private static final EnumMap<BlendMode, String> BLEND_MODE_FUNCTIONS;
    private static final String PRIV_BLEND_GET_LUM = "float _blend_get_lum(vec3 color) {\n    return dot(vec3(0.299, 0.587, 0.114), color);\n}\n";
    public static final String BLEND_DARKER_COLOR = "vec4 blend_darker_color(vec4 src, vec4 dst) {\n    return mix(src * (1 - dst.a) + dst,\n               src + dst * (1 - src.a),\n               bvec4(_blend_get_lum(src.rgb) <= _blend_get_lum(dst.rgb)));\n}\n";
    public static final String BLEND_LIGHTER_COLOR = "vec4 blend_lighter_color(vec4 src, vec4 dst) {\n    return mix(src * (1 - dst.a) + dst,\n               src + dst * (1 - src.a),\n               bvec4(_blend_get_lum(src.rgb) >= _blend_get_lum(dst.rgb)));\n}\n";
    private static final String PRIV_BLEND_SET_LUM = "vec3 _blend_set_lum(vec3 cbase,\n                    vec3 clum, float alum,\n                    float alpha) {\n    float ldiff = _blend_get_lum(clum) * alum - _blend_get_lum(cbase);\n    cbase += ldiff;\n    float lum = _blend_get_lum(cbase);\n    float mincol = min(min(cbase.r, cbase.g), cbase.b);\n    float maxcol = max(max(cbase.r, cbase.g), cbase.b);\n    if (mincol < 0 && lum != mincol) {\n        cbase = lum + ((cbase - lum) * lum) / (lum - mincol);\n    }\n    if (maxcol > alpha && maxcol != lum) {\n        cbase = lum + ((cbase - lum) * (alpha - lum)) / (maxcol - lum);\n    }\n    return cbase;\n}\n";
    private static final String PRIV_BLEND_SET_LUM_SAT = "vec3 _blend_set_lum_sat(vec3 cbase,\n                        vec3 csat, float asat,\n                        vec3 clum, float alum,\n                        float alpha) {\n    float minbase = min(min(cbase.r, cbase.g), cbase.b);\n    float sbase = max(max(cbase.r, cbase.g), cbase.b) - minbase;\n    if (sbase > 0) {\n        float ssat = (max(max(csat.r, csat.g), csat.b) - min(min(csat.r, csat.g), csat.b)) * asat;\n        cbase = (cbase - minbase) * ssat / sbase;\n    } else {\n        cbase = vec3(0);\n    }\n    return _blend_set_lum(cbase, clum, alum, alpha);\n}\n";
    public static final String BLEND_HUE = "vec4 blend_hue(vec4 src, vec4 dst) {\n    float alpha = src.a * dst.a;\n    vec3 c = src.rgb * dst.a;\n    c = _blend_set_lum_sat(c, dst.rgb, src.a, dst.rgb, src.a, alpha);\n    return vec4(c + src.rgb * (1 - dst.a) + dst.rgb * (1 - src.a),\n                src.a + dst.a - alpha);\n}\n";
    public static final String BLEND_SATURATION = "vec4 blend_saturation(vec4 src, vec4 dst) {\n    float alpha = src.a * dst.a;\n    vec3 c = dst.rgb * src.a;\n    c = _blend_set_lum_sat(c, src.rgb, dst.a, dst.rgb, src.a, alpha);\n    return vec4(c + src.rgb * (1 - dst.a) + dst.rgb * (1 - src.a),\n                src.a + dst.a - alpha);\n}\n";
    public static final String BLEND_COLOR = "vec4 blend_color(vec4 src, vec4 dst) {\n    float alpha = src.a * dst.a;\n    vec3 c = src.rgb * dst.a;\n    c = _blend_set_lum(c, dst.rgb, src.a, alpha);\n    return vec4(c + src.rgb * (1 - dst.a) + dst.rgb * (1 - src.a),\n                src.a + dst.a - alpha);\n}\n";
    public static final String BLEND_LUMINOSITY = "vec4 blend_luminosity(vec4 src, vec4 dst) {\n    float alpha = src.a * dst.a;\n    vec3 c = dst.rgb * src.a;\n    c = _blend_set_lum(c, src.rgb, dst.a, alpha);\n    return vec4(c + src.rgb * (1 - dst.a) + dst.rgb * (1 - src.a),\n                src.a + dst.a - alpha);\n}\n";
    public static final String ARC_BLEND = "vec4 arc_blend(vec4 src, vec4 dst, int blendMode) {\n    const int kClear        = 0;\n    const int kSrc          = 1;\n    const int kDst          = 2;\n    const int kSrcOver      = 3;\n    const int kDstOver      = 4;\n    const int kSrcIn        = 5;\n    const int kDstIn        = 6;\n    const int kSrcOut       = 7;\n    const int kDstOut       = 8;\n    const int kSrcATop      = 9;\n    const int kDstATop      = 10;\n    const int kXor          = 11;\n    const int kPlus         = 12;\n    const int kPlusClamped  = 13;\n    const int kMinus        = 14;\n    const int kMinusClamped = 15;\n    const int kModulate     = 16;\n    const int kMultiply     = 17;\n    const int kScreen       = 18;\n    const int kOverlay      = 19;\n    const int kDarken       = 20;\n    const int kLighten      = 21;\n    const int kColorDodge   = 22;\n    const int kColorBurn    = 23;\n    const int kHardLight    = 24;\n    const int kSoftLight    = 25;\n    const int kDifference   = 26;\n    const int kExclusion    = 27;\n    const int kSubtract     = 28;\n    const int kDivide       = 29;\n    const int kLinearDodge  = 30;\n    const int kLinearBurn   = 31;\n    const int kVividLight   = 32;\n    const int kLinearLight  = 33;\n    const int kPinLight     = 34;\n    const int kHardMix      = 35;\n    const int kDarkerColor  = 36;\n    const int LighterColor  = 37;\n    const int kHue          = 38;\n    const int kSaturation   = 39;\n    const int kColor        = 40;\n    const int kLuminosity   = 41;\n\n    switch (blendMode) {\n        case kClear        : return blend_clear          (src,dst);\n        case kSrc          : return blend_src            (src,dst);\n        case kDst          : return blend_dst            (src,dst);\n        case kSrcOver      : return blend_src_over       (src,dst);\n        case kDstOver      : return blend_dst_over       (src,dst);\n        case kSrcIn        : return blend_src_in         (src,dst);\n        case kDstIn        : return blend_dst_in         (src,dst);\n        case kSrcOut       : return blend_src_out        (src,dst);\n        case kDstOut       : return blend_dst_out        (src,dst);\n        case kSrcATop      : return blend_src_atop       (src,dst);\n        case kDstATop      : return blend_dst_atop       (src,dst);\n        case kXor          : return blend_xor            (src,dst);\n        case kPlus         : return blend_plus           (src,dst);\n        case kPlusClamped  : return blend_plus_clamped   (src,dst);\n        case kMinus        : return blend_minus          (src,dst);\n        case kMinusClamped : return blend_minus_clamped  (src,dst);\n        case kModulate     : return blend_modulate       (src,dst);\n        case kMultiply     : return blend_multiply       (src,dst);\n        case kScreen       : return blend_screen         (src,dst);\n        case kOverlay      : return blend_overlay        (src,dst);\n        case kDarken       : return blend_darken         (src,dst);\n        case kLighten      : return blend_lighten        (src,dst);\n        case kColorDodge   : return blend_color_dodge    (src,dst);\n        case kColorBurn    : return blend_color_burn     (src,dst);\n        case kHardLight    : return blend_hard_light     (src,dst);\n        case kSoftLight    : return blend_soft_light     (src,dst);\n        case kDifference   : return blend_difference     (src,dst);\n        case kExclusion    : return blend_exclusion      (src,dst);\n        case kSubtract     : return blend_subtract       (src,dst);\n        case kDivide       : return blend_divide         (src,dst);\n        case kLinearDodge  : return blend_linear_dodge   (src,dst);\n        case kLinearBurn   : return blend_linear_burn    (src,dst);\n        case kVividLight   : return blend_vivid_light    (src,dst);\n        case kLinearLight  : return blend_linear_light   (src,dst);\n        case kPinLight     : return blend_pin_light      (src,dst);\n        case kHardMix      : return blend_hard_mix       (src,dst);\n        case kDarkerColor  : return blend_darker_color   (src,dst);\n        case LighterColor  : return blend_lighter_color  (src,dst);\n        case kHue          : return blend_hue            (src,dst);\n        case kSaturation   : return blend_saturation     (src,dst);\n        case kColor        : return blend_color          (src,dst);\n        case kLuminosity   : return blend_luminosity     (src,dst);\n        default            : return vec4(0);\n    }\n}\n";
    public static final String ARC_PORTER_DUFF_BLEND = "vec4 arc_porter_duff_blend(vec4 src, vec4 dst, vec4 blendOp) {\n    // The supported blend modes all have coefficients that are of the form (C + S*alpha), where\n    // alpha is the other color's alpha channel. C can be 0 or 1, S can be -1, 0, or 1.\n    vec2 coeff = blendOp.xy + blendOp.zw * vec2(dst.a, src.a);\n    return src * coeff.x + dst * coeff.y;\n}\n";
    private final FragmentStage[] mBuiltinCodeSnippets = new FragmentStage[FragmentStage.kBuiltinStageIDCount];

    public ShaderCodeSource() {
        this.mBuiltinCodeSnippets[0] = new FragmentStage("Error", 1, "arc_error", new String[]{ARC_ERROR}, FragmentStage.NO_UNIFORMS, FragmentStage.NO_SAMPLERS, ShaderCodeSource::generateDefaultExpression, 0);
        this.mBuiltinCodeSnippets[1] = new FragmentStage("Passthrough", 2, "arc_passthrough", new String[]{ARC_PASSTHROUGH}, FragmentStage.NO_UNIFORMS, FragmentStage.NO_SAMPLERS, ShaderCodeSource::generateDefaultExpression, 0);
        this.mBuiltinCodeSnippets[2] = new FragmentStage("SolidColor", 0, "arc_solid_color", new String[]{ARC_SOLID_COLOR}, new FragmentStage.Uniform[]{new FragmentStage.Uniform(16, "u_Color")}, FragmentStage.NO_SAMPLERS, ShaderCodeSource::generateDefaultExpression, 0);
        this.mBuiltinCodeSnippets[3] = new FragmentStage("RGBOpaquePaintColor", 0, "arc_rgb_opaque", new String[]{ARC_RGB_OPAQUE}, PAINT_COLOR_UNIFORMS, FragmentStage.NO_SAMPLERS, ShaderCodeSource::generateDefaultExpression, 0);
        this.mBuiltinCodeSnippets[4] = new FragmentStage("AlphaOnlyPaintColor", 0, "arc_alpha_only", new String[]{ARC_ALPHA_ONLY}, PAINT_COLOR_UNIFORMS, FragmentStage.NO_SAMPLERS, ShaderCodeSource::generateDefaultExpression, 0);
        this.mBuiltinCodeSnippets[5] = new FragmentStage("LinearGradient4", 1, "arc_linear_grad_4_shader", new String[]{PRIV_TILE_GRAD, PRIV_LINEAR_GRAD_LAYOUT, PRIV_COLORIZE_GRAD_4, PRIV_CSS_LAB_TO_XYZ, PRIV_CSS_HCL_TO_LAB, PRIV_CSS_OKLAB_TO_LINEAR_SRGB, PRIV_OKLAB_GAMUT_MAP_TO_LINEAR_SRGB, PRIV_CSS_HSL_TO_SRGB, PRIV_CSS_HWB_TO_SRGB, PRIV_INTERPOLATED_TO_RGB_UNPREMUL, ARC_LINEAR_GRAD_4_SHADER}, new FragmentStage.Uniform[]{GRAD_4_COLORS, GRAD_4_OFFSETS, TILE_MODE_X, GRAD_COLOR_SPACE, GRAD_DO_UNPREMUL}, FragmentStage.NO_SAMPLERS, ShaderCodeSource::generateDefaultExpression, 0);
        this.mBuiltinCodeSnippets[6] = new FragmentStage("LinearGradient8", 1, "arc_linear_grad_8_shader", new String[]{PRIV_TILE_GRAD, PRIV_LINEAR_GRAD_LAYOUT, PRIV_COLORIZE_GRAD_8, PRIV_CSS_LAB_TO_XYZ, PRIV_CSS_HCL_TO_LAB, PRIV_CSS_OKLAB_TO_LINEAR_SRGB, PRIV_OKLAB_GAMUT_MAP_TO_LINEAR_SRGB, PRIV_CSS_HSL_TO_SRGB, PRIV_CSS_HWB_TO_SRGB, PRIV_INTERPOLATED_TO_RGB_UNPREMUL, ARC_LINEAR_GRAD_8_SHADER}, new FragmentStage.Uniform[]{GRAD_8_COLORS, GRAD_8_OFFSETS, TILE_MODE_X, GRAD_COLOR_SPACE, GRAD_DO_UNPREMUL}, FragmentStage.NO_SAMPLERS, ShaderCodeSource::generateDefaultExpression, 0);
        this.mBuiltinCodeSnippets[7] = new FragmentStage("RadialGradient4", 1, "arc_radial_grad_4_shader", new String[]{PRIV_TILE_GRAD, PRIV_RADIAL_GRAD_LAYOUT, PRIV_COLORIZE_GRAD_4, PRIV_CSS_LAB_TO_XYZ, PRIV_CSS_HCL_TO_LAB, PRIV_CSS_OKLAB_TO_LINEAR_SRGB, PRIV_OKLAB_GAMUT_MAP_TO_LINEAR_SRGB, PRIV_CSS_HSL_TO_SRGB, PRIV_CSS_HWB_TO_SRGB, PRIV_INTERPOLATED_TO_RGB_UNPREMUL, ARC_RADIAL_GRAD_4_SHADER}, new FragmentStage.Uniform[]{GRAD_4_COLORS, GRAD_4_OFFSETS, TILE_MODE_X, GRAD_COLOR_SPACE, GRAD_DO_UNPREMUL}, FragmentStage.NO_SAMPLERS, ShaderCodeSource::generateDefaultExpression, 0);
        this.mBuiltinCodeSnippets[8] = new FragmentStage("RadialGradient8", 1, "arc_radial_grad_8_shader", new String[]{PRIV_TILE_GRAD, PRIV_RADIAL_GRAD_LAYOUT, PRIV_COLORIZE_GRAD_8, PRIV_CSS_LAB_TO_XYZ, PRIV_CSS_HCL_TO_LAB, PRIV_CSS_OKLAB_TO_LINEAR_SRGB, PRIV_OKLAB_GAMUT_MAP_TO_LINEAR_SRGB, PRIV_CSS_HSL_TO_SRGB, PRIV_CSS_HWB_TO_SRGB, PRIV_INTERPOLATED_TO_RGB_UNPREMUL, ARC_RADIAL_GRAD_8_SHADER}, new FragmentStage.Uniform[]{GRAD_8_COLORS, GRAD_8_OFFSETS, TILE_MODE_X, GRAD_COLOR_SPACE, GRAD_DO_UNPREMUL}, FragmentStage.NO_SAMPLERS, ShaderCodeSource::generateDefaultExpression, 0);
        this.mBuiltinCodeSnippets[9] = new FragmentStage("AngularGradient4", 1, "arc_angular_grad_4_shader", new String[]{PRIV_TILE_GRAD, PRIV_ANGULAR_GRAD_LAYOUT, PRIV_COLORIZE_GRAD_4, PRIV_CSS_LAB_TO_XYZ, PRIV_CSS_HCL_TO_LAB, PRIV_CSS_OKLAB_TO_LINEAR_SRGB, PRIV_OKLAB_GAMUT_MAP_TO_LINEAR_SRGB, PRIV_CSS_HSL_TO_SRGB, PRIV_CSS_HWB_TO_SRGB, PRIV_INTERPOLATED_TO_RGB_UNPREMUL, ARC_ANGULAR_GRAD_4_SHADER}, new FragmentStage.Uniform[]{GRAD_4_COLORS, GRAD_4_OFFSETS, GRAD_BIAS, GRAD_SCALE, TILE_MODE_X, GRAD_COLOR_SPACE, GRAD_DO_UNPREMUL}, FragmentStage.NO_SAMPLERS, ShaderCodeSource::generateDefaultExpression, 0);
        this.mBuiltinCodeSnippets[10] = new FragmentStage("AngularGradient8", 1, "arc_angular_grad_8_shader", new String[]{PRIV_TILE_GRAD, PRIV_ANGULAR_GRAD_LAYOUT, PRIV_COLORIZE_GRAD_8, PRIV_CSS_LAB_TO_XYZ, PRIV_CSS_HCL_TO_LAB, PRIV_CSS_OKLAB_TO_LINEAR_SRGB, PRIV_OKLAB_GAMUT_MAP_TO_LINEAR_SRGB, PRIV_CSS_HSL_TO_SRGB, PRIV_CSS_HWB_TO_SRGB, PRIV_INTERPOLATED_TO_RGB_UNPREMUL, ARC_ANGULAR_GRAD_8_SHADER}, new FragmentStage.Uniform[]{GRAD_8_COLORS, GRAD_8_OFFSETS, GRAD_BIAS, GRAD_SCALE, TILE_MODE_X, GRAD_COLOR_SPACE, GRAD_DO_UNPREMUL}, FragmentStage.NO_SAMPLERS, ShaderCodeSource::generateDefaultExpression, 0);
        this.mBuiltinCodeSnippets[16] = new FragmentStage("LocalMatrixShader", 3, "LocalMatrix", FragmentStage.NO_FUNCTIONS, new FragmentStage.Uniform[]{new FragmentStage.Uniform(18, "u_LocalMatrix")}, FragmentStage.NO_SAMPLERS, (node, localCoords, priorStageOutput, blenderDstColor, output, code) -> {
            assert (node.codeID() == 16);
            assert (node.numChildren() == 1);
            String newPerspCoordsName = ShaderCodeSource.getMangledName("newPerspCoords", node.stageIndex());
            String newLocalCoordsName = ShaderCodeSource.getMangledName("newLocalCoords", node.stageIndex());
            String localMatrixName = ShaderCodeSource.getMangledName(node.stage().mUniforms[0].name(), node.stageIndex());
            code.format("{\nvec3 %1$s = %3$s * vec3(%4$s, 1);\nvec2 %2$s = %1$s.xy / %1$s.z;\n", newPerspCoordsName, newLocalCoordsName, localMatrixName, localCoords);
            FragmentNode childNode = node.childAt(0);
            childNode.stage().mExpressionGenerator.generate(childNode, newLocalCoordsName, priorStageOutput, "vec4(1)", output, code);
            code.format("}\n", new Object[0]);
        }, 1);
        this.mBuiltinCodeSnippets[17] = new FragmentStage("ImageShader", 1, "arc_image_shader", new String[]{PRIV_TILE, PRIV_SAMPLE_IMAGE_SUBSET, ARC_IMAGE_SHADER}, new FragmentStage.Uniform[]{INV_IMAGE_SIZE, SUBSET, new FragmentStage.Uniform(27, "u_FilterMode"), TILE_MODE_X, TILE_MODE_Y}, new FragmentStage.Sampler[]{new FragmentStage.Sampler(35, "u_Sampler")}, ShaderCodeSource::generateDefaultExpression, 0);
        this.mBuiltinCodeSnippets[18] = new FragmentStage("CubicImageShader", 1, "arc_cubic_image_shader", new String[]{PRIV_TILE, PRIV_SAMPLE_CUBIC_IMAGE_SUBSET, PRIV_CUBIC_FILTER_IMAGE, ARC_CUBIC_IMAGE_SHADER}, new FragmentStage.Uniform[]{SUBSET, new FragmentStage.Uniform(19, "u_CubicCoeffs"), new FragmentStage.Uniform(27, "u_CubicClamp"), TILE_MODE_X, TILE_MODE_Y}, new FragmentStage.Sampler[]{new FragmentStage.Sampler(35, "u_Sampler")}, ShaderCodeSource::generateDefaultExpression, 0);
        this.mBuiltinCodeSnippets[19] = new FragmentStage("HardwareImageShader", 1, "arc_hw_image_shader", new String[]{ARC_HW_IMAGE_SHADER}, new FragmentStage.Uniform[]{INV_IMAGE_SIZE}, new FragmentStage.Sampler[]{new FragmentStage.Sampler(35, "u_Sampler")}, ShaderCodeSource::generateDefaultExpression, 0);
        this.mBuiltinCodeSnippets[20] = new FragmentStage("DitherShader", 2, "arc_dither_shader", new String[]{ARC_DITHER_SHADER}, new FragmentStage.Uniform[]{new FragmentStage.Uniform(13, "u_Range")}, FragmentStage.NO_SAMPLERS, ShaderCodeSource::generateDefaultExpression, 0);
        this.mBuiltinCodeSnippets[21] = new FragmentStage("ColorSpaceTransform", 2, "arc_color_space_transform", new String[]{PRIV_TRANSFER_FUNCTION, PRIV_INV_TRANSFER_FUNCTION, ARC_COLOR_SPACE_TRANSFORM}, new FragmentStage.Uniform[]{XFORM_FLAGS, XFORM_SRC_TF, XFORM_GAMUT_TRANSFORM, XFORM_DST_TF}, FragmentStage.NO_SAMPLERS, ShaderCodeSource::generateDefaultExpression, 0);
        this.mBuiltinCodeSnippets[22] = new FragmentStage("Blend", 0, "Blend", FragmentStage.NO_FUNCTIONS, FragmentStage.NO_UNIFORMS, FragmentStage.NO_SAMPLERS, ShaderCodeSource::generateComposeExpression, 3);
        this.mBuiltinCodeSnippets[23] = new FragmentStage("BlendModeBlender", 6, "arc_blend", new String[]{PRIV_BLEND_GET_LUM, PRIV_BLEND_SET_LUM, PRIV_BLEND_SET_LUM_SAT, BLEND_CLEAR, BLEND_SRC, BLEND_DST, BLEND_SRC_OVER, BLEND_DST_OVER, BLEND_SRC_IN, BLEND_DST_IN, BLEND_SRC_OUT, BLEND_DST_OUT, BLEND_SRC_ATOP, BLEND_DST_ATOP, BLEND_XOR, BLEND_PLUS, BLEND_PLUS_CLAMPED, BLEND_MINUS, BLEND_MINUS_CLAMPED, BLEND_MODULATE, BLEND_MULTIPLY, BLEND_SCREEN, BLEND_OVERLAY, BLEND_DARKEN, BLEND_LIGHTEN, BLEND_COLOR_DODGE, BLEND_COLOR_BURN, BLEND_HARD_LIGHT, BLEND_SOFT_LIGHT, BLEND_DIFFERENCE, BLEND_EXCLUSION, BLEND_SUBTRACT, BLEND_DIVIDE, BLEND_LINEAR_DODGE, BLEND_LINEAR_BURN, BLEND_VIVID_LIGHT, BLEND_LINEAR_LIGHT, BLEND_PIN_LIGHT, BLEND_HARD_MIX, BLEND_DARKER_COLOR, BLEND_LIGHTER_COLOR, BLEND_HUE, BLEND_SATURATION, BLEND_COLOR, BLEND_LUMINOSITY, ARC_BLEND}, new FragmentStage.Uniform[]{new FragmentStage.Uniform(27, "u_BlendMode")}, FragmentStage.NO_SAMPLERS, ShaderCodeSource::generateDefaultExpression, 0);
        this.mBuiltinCodeSnippets[24] = new FragmentStage("PorterDuffBlender", 6, "arc_porter_duff_blend", new String[]{ARC_PORTER_DUFF_BLEND}, new FragmentStage.Uniform[]{new FragmentStage.Uniform(16, "u_Coeffs")}, FragmentStage.NO_SAMPLERS, ShaderCodeSource::generateDefaultExpression, 0);
        this.mBuiltinCodeSnippets[25] = new FragmentStage("PrimitiveColor", 16, "arc_color_space_transform", new String[]{PRIV_TRANSFER_FUNCTION, PRIV_INV_TRANSFER_FUNCTION, ARC_COLOR_SPACE_TRANSFORM}, new FragmentStage.Uniform[]{XFORM_FLAGS, XFORM_SRC_TF, XFORM_GAMUT_TRANSFORM, XFORM_DST_TF}, FragmentStage.NO_SAMPLERS, ShaderCodeSource::generateDefaultExpression, 0);
        this.mBuiltinCodeSnippets[26] = new FragmentStage("Compose", 0, "Compose", FragmentStage.NO_FUNCTIONS, FragmentStage.NO_UNIFORMS, FragmentStage.NO_SAMPLERS, ShaderCodeSource::generateComposeExpression, 2);
        for (int i = 0; i < BlendMode.COUNT; ++i) {
            BlendMode mode = BlendMode.modeAt(i);
            String function = BLEND_MODE_FUNCTIONS.get(mode);
            if (function == null) continue;
            this.mBuiltinCodeSnippets[27 + i] = new FragmentStage(mode.name(), 6, mode.getBlendFuncName(), new String[]{function}, FragmentStage.NO_UNIFORMS, FragmentStage.NO_SAMPLERS, ShaderCodeSource::generateDefaultExpression, 0);
        }
        this.mBuiltinCodeSnippets[27 + BlendMode.DARKER_COLOR.ordinal()] = new FragmentStage("DarkerColor", 6, "blend_darker_color", new String[]{PRIV_BLEND_GET_LUM, BLEND_DARKER_COLOR}, FragmentStage.NO_UNIFORMS, FragmentStage.NO_SAMPLERS, ShaderCodeSource::generateDefaultExpression, 0);
        this.mBuiltinCodeSnippets[27 + BlendMode.LIGHTER_COLOR.ordinal()] = new FragmentStage("LighterColor", 6, "blend_lighter_color", new String[]{PRIV_BLEND_GET_LUM, BLEND_LIGHTER_COLOR}, FragmentStage.NO_UNIFORMS, FragmentStage.NO_SAMPLERS, ShaderCodeSource::generateDefaultExpression, 0);
        this.mBuiltinCodeSnippets[27 + BlendMode.HUE.ordinal()] = new FragmentStage("Hue", 6, "blend_hue", new String[]{PRIV_BLEND_GET_LUM, PRIV_BLEND_SET_LUM, PRIV_BLEND_SET_LUM_SAT, BLEND_HUE}, FragmentStage.NO_UNIFORMS, FragmentStage.NO_SAMPLERS, ShaderCodeSource::generateDefaultExpression, 0);
        this.mBuiltinCodeSnippets[27 + BlendMode.SATURATION.ordinal()] = new FragmentStage("Saturation", 6, "blend_saturation", new String[]{PRIV_BLEND_GET_LUM, PRIV_BLEND_SET_LUM, PRIV_BLEND_SET_LUM_SAT, BLEND_SATURATION}, FragmentStage.NO_UNIFORMS, FragmentStage.NO_SAMPLERS, ShaderCodeSource::generateDefaultExpression, 0);
        this.mBuiltinCodeSnippets[27 + BlendMode.COLOR.ordinal()] = new FragmentStage("Color", 6, "blend_color", new String[]{PRIV_BLEND_GET_LUM, PRIV_BLEND_SET_LUM, BLEND_COLOR}, FragmentStage.NO_UNIFORMS, FragmentStage.NO_SAMPLERS, ShaderCodeSource::generateDefaultExpression, 0);
        this.mBuiltinCodeSnippets[27 + BlendMode.LUMINOSITY.ordinal()] = new FragmentStage("Luminosity", 6, "blend_luminosity", new String[]{PRIV_BLEND_GET_LUM, PRIV_BLEND_SET_LUM, BLEND_LUMINOSITY}, FragmentStage.NO_UNIFORMS, FragmentStage.NO_SAMPLERS, ShaderCodeSource::generateDefaultExpression, 0);
    }

    public FragmentStage findStage(int stageId) {
        if (stageId < 0) {
            return null;
        }
        if (stageId < FragmentStage.kBuiltinStageIDCount) {
            return this.mBuiltinCodeSnippets[stageId];
        }
        return null;
    }

    public static String getMangledName(String baseName, int manglingSuffix) {
        if (manglingSuffix >= 0) {
            return baseName + "_" + manglingSuffix;
        }
        return baseName;
    }

    public static String invoke_node(FragmentNode node, String localCoords, String priorStageOutput, String blenderDstColor, Formatter code) {
        String output = ShaderCodeSource.getMangledName("outColor", node.stageIndex());
        code.format("// [%d] %s\nvec4 %s;\n", node.stageIndex(), node.stage().mName, output);
        node.stage().mExpressionGenerator.generate(node, localCoords, priorStageOutput, blenderDstColor, output, code);
        return output;
    }

    public static String invoke_child(FragmentNode child, String localCoords, String priorStageOutput, String blenderDstColor, FragmentNode outputNode, String outputBaseName, byte outputType, Formatter code) {
        String output = ShaderCodeSource.getMangledName(outputBaseName, outputNode.stageIndex());
        code.format("// [%d] %s\n%s %s;\n", child.stageIndex(), child.stage().mName, SLDataType.typeString(outputType), output);
        code.format("{\n", new Object[0]);
        child.stage().mExpressionGenerator.generate(child, localCoords, priorStageOutput, blenderDstColor, output, code);
        code.format("}\n", new Object[0]);
        return output;
    }

    private static void appendStageArguments(FragmentNode node, String localCoords, String priorStageOutput, String blenderDstColor, StringJoiner args) {
        FragmentStage stage = node.stage();
        if ((stage.mRequirementFlags & 1) != 0) {
            args.add(localCoords);
        }
        if ((stage.mRequirementFlags & 2) != 0) {
            args.add(priorStageOutput);
        }
        if ((stage.mRequirementFlags & 4) != 0) {
            args.add(blenderDstColor);
        }
        if ((stage.mRequirementFlags & 0x10) != 0) {
            args.add("primitiveColor");
        }
        for (FragmentStage.Uniform uniform : stage.mUniforms) {
            if (uniform.name().startsWith("SV_")) {
                args.add(uniform.name());
                continue;
            }
            args.add(ShaderCodeSource.getMangledName(uniform.name(), node.stageIndex()));
        }
        for (Record record : stage.mSamplers) {
            args.add(ShaderCodeSource.getMangledName(((FragmentStage.Sampler)record).name(), node.stageIndex()));
        }
    }

    private static void generateDefaultExpression(FragmentNode node, String localCoords, String priorStageOutput, String blenderDstColor, String output, Formatter code) {
        StringJoiner arguments = new StringJoiner(",");
        ShaderCodeSource.appendStageArguments(node, localCoords, priorStageOutput, blenderDstColor, arguments);
        if (node.numChildren() > 0) {
            for (FragmentNode child : node.children()) {
                arguments.add(ShaderCodeSource.invoke_child(child, localCoords, priorStageOutput, blenderDstColor, child, "outColor", (byte)16, code));
            }
        }
        code.format("%s = %s(%s);\n", output, node.stage().mStaticFunctionName, arguments);
    }

    private static void generateComposeExpression(FragmentNode node, String localCoords, String priorStageOutput, String blenderDstColor, String output, Formatter code) {
        FragmentNode child;
        assert (node.numChildren() >= 2);
        FragmentNode outer = node.childAt(node.numChildren() - 1);
        String outerLocalCoords = localCoords;
        String outerPriorStageOutput = priorStageOutput;
        String outerBlenderDstColor = blenderDstColor;
        code.format("{\n", new Object[0]);
        int childIndex = 0;
        if ((outer.requirementFlags() & 1) != 0) {
            child = node.childAt(childIndex++);
            outerLocalCoords = ShaderCodeSource.invoke_child(child, localCoords, priorStageOutput, blenderDstColor, node, "outerLocalCoords", (byte)14, code);
        }
        if ((outer.requirementFlags() & 2) != 0) {
            child = node.childAt(childIndex++);
            outerPriorStageOutput = ShaderCodeSource.invoke_child(child, localCoords, priorStageOutput, blenderDstColor, node, "outerPriorStageOutput", (byte)16, code);
        }
        if ((outer.requirementFlags() & 4) != 0) {
            child = node.childAt(childIndex++);
            outerBlenderDstColor = ShaderCodeSource.invoke_child(child, localCoords, priorStageOutput, blenderDstColor, node, "outerBlenderDstColor", (byte)16, code);
        }
        assert (childIndex + 1 == node.numChildren());
        code.format("// [%d] %s\n", outer.stageIndex(), outer.stage().mName);
        outer.stage().mExpressionGenerator.generate(outer, outerLocalCoords, outerPriorStageOutput, outerBlenderDstColor, output, code);
        code.format("}\n", new Object[0]);
    }

    public static void emitDefinitions(FragmentNode[] nodes, IdentityHashMap<String, String> added, Formatter code) {
        for (FragmentNode node : nodes) {
            if (node.numChildren() > 0) {
                ShaderCodeSource.emitDefinitions(node.children(), added, code);
            }
            for (String function : node.stage().mRequiredFunctions) {
                if (added.put(function, function) != null) continue;
                code.format(function, new Object[0]);
            }
        }
    }

    static {
        EnumMap<BlendMode, String> map = new EnumMap<BlendMode, String>(BlendMode.class);
        map.put(BlendMode.CLEAR, BLEND_CLEAR);
        map.put(BlendMode.SRC, BLEND_SRC);
        map.put(BlendMode.DST, BLEND_DST);
        map.put(BlendMode.SRC_OVER, BLEND_SRC_OVER);
        map.put(BlendMode.DST_OVER, BLEND_DST_OVER);
        map.put(BlendMode.SRC_IN, BLEND_SRC_IN);
        map.put(BlendMode.DST_IN, BLEND_DST_IN);
        map.put(BlendMode.SRC_OUT, BLEND_SRC_OUT);
        map.put(BlendMode.DST_OUT, BLEND_DST_OUT);
        map.put(BlendMode.SRC_ATOP, BLEND_SRC_ATOP);
        map.put(BlendMode.DST_ATOP, BLEND_DST_ATOP);
        map.put(BlendMode.XOR, BLEND_XOR);
        map.put(BlendMode.PLUS, BLEND_PLUS);
        map.put(BlendMode.PLUS_CLAMPED, BLEND_PLUS_CLAMPED);
        map.put(BlendMode.MINUS, BLEND_MINUS);
        map.put(BlendMode.MINUS_CLAMPED, BLEND_MINUS_CLAMPED);
        map.put(BlendMode.MODULATE, BLEND_MODULATE);
        map.put(BlendMode.MULTIPLY, BLEND_MULTIPLY);
        map.put(BlendMode.SCREEN, BLEND_SCREEN);
        map.put(BlendMode.OVERLAY, BLEND_OVERLAY);
        map.put(BlendMode.DARKEN, BLEND_DARKEN);
        map.put(BlendMode.LIGHTEN, BLEND_LIGHTEN);
        map.put(BlendMode.COLOR_DODGE, BLEND_COLOR_DODGE);
        map.put(BlendMode.COLOR_BURN, BLEND_COLOR_BURN);
        map.put(BlendMode.HARD_LIGHT, BLEND_HARD_LIGHT);
        map.put(BlendMode.SOFT_LIGHT, BLEND_SOFT_LIGHT);
        map.put(BlendMode.DIFFERENCE, BLEND_DIFFERENCE);
        map.put(BlendMode.EXCLUSION, BLEND_EXCLUSION);
        map.put(BlendMode.SUBTRACT, BLEND_SUBTRACT);
        map.put(BlendMode.DIVIDE, BLEND_DIVIDE);
        map.put(BlendMode.LINEAR_DODGE, BLEND_LINEAR_DODGE);
        map.put(BlendMode.LINEAR_BURN, BLEND_LINEAR_BURN);
        map.put(BlendMode.VIVID_LIGHT, BLEND_VIVID_LIGHT);
        map.put(BlendMode.LINEAR_LIGHT, BLEND_LINEAR_LIGHT);
        map.put(BlendMode.PIN_LIGHT, BLEND_PIN_LIGHT);
        map.put(BlendMode.HARD_MIX, BLEND_HARD_MIX);
        BLEND_MODE_FUNCTIONS = map;
    }
}

